package coreservlets.tags;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.*;
import coreservlets.ServletUtilities;

/** Znacznik, ktry zastpuje specjalne znaki HTML-a (takie jak 
 *  znak mniejsze ni albo wiksze ni) odpowiadajcymi im
 *  znakowymi elementami HTML-a.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class HtmlFilterTag extends SimpleTagSupport {
  public void doTag() throws JspException, IOException {
    // Zapisanie danych wynikowych treci znacznika w buforze
    StringWriter stringWriter = new StringWriter();
    getJspBody().invoke(stringWriter);

    // Przefiltrowanie specjalnych znakw HTML-a
    // (na przykad, "<" zostanie przeksztacone w "&lt;")
    String output =
      ServletUtilities.filter(stringWriter.toString());

    // Wysanie danych wynikowych do klienta
    JspWriter out = getJspContext().getOut();
    out.print(output);
  }
}
